using System;
using System.Net.Mail;


namespace gov.va.med.vbecs.DAL.HL7.OpenLibrary
{

		#region Header

		//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		//<Developers>
		//	<Developer>Brian Tomlin</Developer>
		//</Developers>
		//<SiteName>Hines OIFO</SiteName>
		//<CreationDate>10/19/2004</CreationDate>
		//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		//<summary>This class creates and sends e-mail messages to a designated recipient.</summary>

		#endregion

	/// <summary>
	/// Class HL7MailMessage
	/// </summary>
	public class HL7MailMessage
	{

		///<Developers>
		///	<Developer>Brian Tomlin</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/19/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5806"> 
		///		<ExpectedInput>Valid to, from , subject, and body input parameters for CPRS Interface.</ExpectedInput>
		///		<ExpectedOutput>true with a valid mail message sent to recipient.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5807"> 
		///		<ExpectedInput>Empty string for the to input parameter</ExpectedInput>
	///		<ExpectedOutput>HL7Exception for undefined mail recipient.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5814"> 
		///		<ExpectedInput>Valid to, from , subject, and body input parameters for Patient Update Interface.</ExpectedInput>
		///		<ExpectedOutput>true with a valid mail message sent to recipient.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="0" testid ="5815"> 
		///		<ExpectedInput>Valid to, from , subject, and body input parameters for Patient Merge Interface.</ExpectedInput>
		///		<ExpectedOutput>true with a valid mail message sent to recipient.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// This method is used to send an SMTP mail message via the smtp.DNS    SMTP server to the VBECS HL7 Administrator.
		/// </summary>
		/// <param name="to">valid email address for the VBECS HL7 Administrator.</param>
		/// <param name="from">valid email address.</param>
		/// <param name="subject">email messages subject.</param>
		/// <param name="body">email messages body.</param>
		/// <param name="smtpServer">smtp server used to deliver message (defaults to smtp.DNS   )</param>
		public bool SendMessage( string to, string from, string subject, string body, string smtpServer )
		{
            //CVS VBECS 2.0 rewrote to be compliant with .Net 4.0
			if( (to == string.Empty) || (to == null) )
			{
				throw( new HL7Exception( "Mail recipient undefined" ) );
			}
            // Instantiate a new instance of MailMessage
            MailMessage mMailMessage = new MailMessage();

            // Set the sender address of the mail message
            mMailMessage.From = new MailAddress(from);
            // Set the recepient address of the mail message
            mMailMessage.To.Add(new MailAddress(to));


          
            mMailMessage.Subject = subject;

            //CR 3276
            //Check if body contains a PID segment
            if(body.IndexOf("PID|") > -1 || body.IndexOf("PID^") > -1)
            {
                body = "Maximum number of retry attempts met for message. This could be caused by the OERR link being down or bad data sent in the HL7 message.";
            }
           
           
            // Set the body of the mail message
            mMailMessage.Body = body;


            // Set the format of the mail message body as HTML
            mMailMessage.IsBodyHtml = false;
            // Set the priority of the mail message to normal
            //Towelie??? Want to get ...
            mMailMessage.Priority = MailPriority.High;

            // Instantiate a new instance of SmtpClient
		    SmtpClient mSmtpClient = new SmtpClient(smtpServer);    //Dammit Towlee!!
            try
            {
                // Send the mail message
                mSmtpClient.Send(mMailMessage);
                return true;
            }          
           	catch( Exception e )
			{
				string errorMessage = "";
				Exception curException = e;
				while( curException != null )
				{
					errorMessage += curException.Message + "\n";
					curException = curException.InnerException;
				}
				throw new Exception( errorMessage );
			}
		}
	}
}
